<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('activities', function (Blueprint $table) {
            $table->id();

            // Who/what the activity is related to
            $table->enum('related_to_type', ['customer', 'corporate_customer', 'lead'])->index();
            $table->unsignedBigInteger('related_to_id')->index();

            // Activity details
            $table->enum('activity_type', [
                'call',
                'email',
                'meeting',
                'note',
                'task',
                'status_change',
                'system_event',
                'sms',
                'notification',
            ])->default('note');

            $table->text('description')->nullable();
            $table->string('subject')->nullable();
            $table->timestamp('activity_at')->nullable();

            // User performing the activity
            $table->foreignId('performed_by')->nullable()->constrained('users')->nullOnDelete();

            // Status tracking
            $table->enum('status', ['pending', 'completed', 'cancelled'])->default('completed');
            $table->boolean('is_automated')->default(false);

            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('activities');
    }
};
